/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityColonyFlag
extends TileEntity {
    private ListNBT flag = new ListNBT();
    private ListNBT patterns = new ListNBT();
    public int colonyId = -1;

    public TileEntityColonyFlag() {
        super(MinecoloniesTileEntities.COLONY_FLAG);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("colonyflag", (INBT)this.flag);
        compound.func_218657_a("Patterns", (INBT)this.patterns);
        compound.func_74768_a("colony", this.colonyId);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        IColony colony;
        super.func_230337_a_(state, compound);
        this.flag = compound.func_150295_c("colonyflag", 10);
        this.patterns = compound.func_150295_c("Patterns", 10);
        this.colonyId = compound.func_74762_e("colony");
        if (this.colonyId == -1 && this.func_145830_o() && (colony = IColonyManager.getInstance().getIColony(this.func_145831_w(), this.field_174879_c)) != null) {
            this.colonyId = colony.getID();
            this.func_70296_d();
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 6, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT compound = packet.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), compound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<BannerPattern, DyeColor>> getPatternList() {
        IColonyView colony;
        if (this.field_145850_b != null && this.field_145850_b.func_234923_W_() != null && (colony = IColonyManager.getInstance().getColonyView(this.colonyId, (RegistryKey<World>)this.field_145850_b.func_234923_W_())) != null && this.flag != colony.getColonyFlag()) {
            this.flag = colony.getColonyFlag();
            this.func_70296_d();
        }
        return BannerTileEntity.func_230138_a_((DyeColor)DyeColor.WHITE, (ListNBT)(this.flag.size() > 1 ? this.flag : this.patterns));
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItemClient() {
        ItemStack itemstack = new ItemStack(ModBlocks.blockColonyBanner);
        List<Pair<BannerPattern, DyeColor>> list = this.getPatternList();
        ListNBT nbt = new ListNBT();
        for (Pair<BannerPattern, DyeColor> pair : list) {
            CompoundNBT pairNBT = new CompoundNBT();
            pairNBT.func_74778_a("Pattern", ((BannerPattern)pair.getFirst()).func_190993_b());
            pairNBT.func_74768_a("Color", ((DyeColor)pair.getSecond()).func_196059_a());
            nbt.add((Object)pairNBT);
        }
        if (!nbt.isEmpty()) {
            itemstack.func_190925_c("BlockEntityTag").func_218657_a("Patterns", (INBT)nbt);
        }
        return itemstack;
    }

    public ItemStack getItemServer() {
        return new ItemStack((IItemProvider)ModItems.flagBanner);
    }
}

